/* nag_wav_aux.h
 *
 * Prototypes for wavelet auxiliary functions
 *
 */
///  *	ML 11/10/2005 ORGONAG_DLL													*
/// ML 10/23/2006 NEW_NAG_WAVELET_UPDATE

//#include "nag.h"
/// ML 11/10/2005 ORGONAG_DLL
//#include <OC_nag8.h>

#ifndef __AFX_H__	   //VC
#include <OC_nag8.h>
#endif // !__AFX_H__
/// end ORGONAG_DLL

#define CONST const
#ifdef __cplusplus
extern "C"
{
#endif

#ifndef NAG_BLAS_CRAYPC /* UNIX */
/* And now for the corresponding declarations */

extern void c06pcfn_(
#ifdef __STDC__
  CONST char direct[],
  Complex x[],
  CONST Integer *n,
  Complex work[],
  char errbuf[],
  Integer *ifail,
  CONST int length_1,
  CONST int length_2
#endif
);

#else /* NAG_MSOFT_DLL */

/* And now for the corresponding declarations */



ONAG_NAG_WAV_AUX_FUN __stdcall C06PCF(
  CONST char direct[], int length_direct,
  Complex x[],
  CONST int *n,
  Complex work[],
  int *ifail
);


#define c06pcfn_(DIRECT, X, N, WORK, ERRBUF, IFAIL, DIRECT_length, ERRBUF_length) \
C06PCFN(DIRECT, DIRECT_length, X, N, WORK, ERRBUF, ERRBUF_length, IFAIL)

#endif /* NAG_MSOFT_DLL */

/// ML 10/12/2005
/// ML 11/10/2005 ORGONAG_DLL
#ifdef __AFX_H__	   //VC
#else // !__AFX_H__
/// end ORGONAG_DLL
#pragma	dll(ONAG_ex.dll)
/// ML 11/10/2005 ORGONAG_DLL
#endif // !__AFX_H__

/// end ORGONAG_DLL
#define		ONAG_NAG_WAV_AUX_FUN		void

/// end ML 10/12/2005



/*
 * Filter Initialisation
 *
 */

//extern void nagbiwfn(Nag_WavType wavname, Integer *nld, Integer *ldsh,
ONAG_NAG_WAV_AUX_FUN nagbiwfn(Nag_WavType wavname, Integer *nld, Integer *ldsh,
	      double ld[], Integer *nhd, Integer *hdsh, double hd[], 
	      Integer *nlr, Integer *lrsh, double lr[], Integer *nhr,
	      Integer *hrsh, double hr[], Integer *IFAIL);

	      

ONAG_NAG_WAV_AUX_FUN nagorwfn(Nag_WavType wavname, Integer *nld, Integer *ldsh,
	      double ld[], Integer *nhd, Integer *hdsh, double hd[], 
	      Integer *nlr, Integer *lrsh, double lr[], Integer *nhr,
		     Integer *hrsh, double hr[], Integer *IFAIL);

/*
 * 1D Continuous Real Wavelet Transform (CWT) 
 *
 */


/// ML 10/23/2006 NEW_NAG_WAVELET_UPDATE
//ONAG_NAG_WAV_AUX_FUN nagcwtn(Integer wtype, Integer n, const double x[],
//		    Integer ns, const Integer scales[], double coefs[],
//		    double xhat[], double yhat[], double omega[],
//		    double whatre[], double whatim[], Integer *ierror);
/// end NEW_NAG_WAVELET_UPDATE

/// ML 10/23/2006 NEW_NAG_WAVELET_UPDATE
//ONAG_NAG_WAV_AUX_FUN nag_morlet(Integer n2, double dt, double scale, double omega0,
//		       const double omega[], double whatre[],
//		       double whatim[]);
/// end NEW_NAG_WAVELET_UPDATE

/*
 * Filter Initialisation
 *
 */

ONAG_NAG_WAV_AUX_FUN nagwvfn(Nag_WavType wavname, Integer nf, double *ld, 
	     double *hd, double *lr, double *hr, Integer *IFAIL);

/*
 * 1D Discrete Wavelet Transform (DWT)
 *
 */

ONAG_NAG_WAV_AUX_FUN nagdwtn(Nag_WavModeType mode, Integer n, const double x[], 
	            Integer nlo, Integer lshift, const double ld[], 
		    Integer nhi, Integer hshift, const double hd[], 
		    Integer nc, double ca[], double cd[], 
		    Integer *ierror);

/*
 * Convolution-decimation: single level
 *
 */

/* Periodic extension */
ONAG_NAG_WAV_AUX_FUN perconvdec(Integer n, const double x[], Integer nf, 
		       Integer shift, const double filt[], Integer stride,
		       Integer nc, double c[], Integer *ierror);

/* Zero extension */
ONAG_NAG_WAV_AUX_FUN zeroconvdec(Integer n, const double x[], Integer nf, 
			Integer shift, const double filt[], 
			Integer stride, Integer nc, double c[],
			Integer *ierror);

/* Half-point symmetric extension */
ONAG_NAG_WAV_AUX_FUN hsymconvdec(Integer n, const double x[], Integer nf, 
			Integer shift, const double filt[], Integer stride,
			Integer nc, double c[], Integer *ierror);

/* Whole-point symmetric extension */
ONAG_NAG_WAV_AUX_FUN wsymconvdec(Integer n, const double x[], Integer nf, 
			Integer shift, const double filt[], Integer stride,
			Integer nc, double c[], Integer *ierror);
/* 
 * 1D Inverse Discrete Wavelet Transform (IDWT)
 *
 */

ONAG_NAG_WAV_AUX_FUN nagidwtn(Nag_WavModeType mode, Integer nc, const double ca[], 
		     const double cd[], Integer nlo, Integer lshift,
		     const double lr[], Integer nhi, Integer hshift,
		     const double hr[], Integer n, double y[], 
		     Integer *ierror);

/* Periodic Extension */
ONAG_NAG_WAV_AUX_FUN perdilaconv(Integer nc, const double c[], Integer nf,
			Integer shift, const double filt[], Integer stride,
			double y[], Integer *ierror);

/* Zero extension */
ONAG_NAG_WAV_AUX_FUN zerodilaconv(Integer nc, const double c[], Integer nf,
			 Integer shift, const double filt[], Integer stride,
			 Integer mshift, double y[], Integer *ierror);

/* Half-point symmetric extension */
ONAG_NAG_WAV_AUX_FUN hsymdilaconv(Integer nc, const double c[], Integer nf,
			 Integer shift, const double filt[], Integer stride,
			 double y[], Integer *ierror);

/* Whole-point symmetric extension */
ONAG_NAG_WAV_AUX_FUN wsymdilaconv(Integer nc, const double c[], Integer nf,
			 Integer shift, const double filt[], Integer stride,
			 double y[], Integer *ierror);

/*
 * 2D Discrete Wavelet Transform (DWT2)
 *
 */

ONAG_NAG_WAV_AUX_FUN nagdwt2n(Nag_WavModeType mode, Integer m, Integer n,
		     const double a[], Integer nlo, Integer lshift,
		     const double ld[], Integer nhi, Integer hshift,
		     const double hd[], Integer mc, Integer nc, double ca[],
		     double ch[], double cv[], double cd[], Integer nwork,
		     double work[], Integer *IFAIL);

/*
 * 2D Inverse Discrete Wavelet Transform (IDWT2)
 *
 */

ONAG_NAG_WAV_AUX_FUN nagidwt2n(Nag_WavModeType mode, Integer mc, Integer nc, 
		      const double ca[], const double ch[], 
		      const double cv[], const double cd[], Integer nlo,
		      Integer lshift, const double lr[], Integer nhi,
		      Integer hshift, const double hr[], double b[],
		      Integer nwork, double work[], Integer *IFAIL);

#ifdef __cplusplus
}
#endif
